$ErrorActionPreference = 'Stop'
$version = '8.5.1.1150'
$url = "https://distr.mitok.ru/$version/windows64tc.zip"
$tempDir = Join-Path $env:TEMP "1c-install-$version"
New-Item -ItemType Directory -Force -Path $tempDir | Out-Null

try {
    $zipPath = Join-Path $tempDir "windows64tc.zip"
    Write-Host "Downloading $url..."
    Invoke-WebRequest -Uri $url -OutFile $zipPath -UseBasicParsing

    Write-Host "Extracting..."
    Expand-Archive -Path $zipPath -DestinationPath $tempDir -Force

    $setupExe = Get-ChildItem -Path $tempDir -Recurse -Filter "setup.exe" | Select-Object -First 1
    if (-not $setupExe) { throw "setup.exe not found" }

    Write-Host "Installing 1C Thin Client $version..."
    $process = Start-Process -FilePath $setupExe.FullName -ArgumentList '/S' -Wait -PassThru -NoNewWindow

    if ($process.ExitCode -ne 0) { throw "Install failed: $($process.ExitCode)" }
    Write-Host "Done!"
} finally {
    Remove-Item -Path $tempDir -Recurse -Force -ErrorAction SilentlyContinue
}
